/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.resource.crate.CountFunctionRegistry;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.resource.crate.ICountFunctionAdapter;
import dev.toma.gunsrpg.resource.util.functions.IFunction;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.lang.reflect.Type;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class CountFunctionAdapter
implements JsonDeserializer<ICountFunction> {
    private final IFunction range;

    public CountFunctionAdapter(IFunction range) {
        this.range = range;
    }

    public static CountFunctionAdapter positive() {
        return new CountFunctionAdapter(input -> input >= 0);
    }

    public ICountFunction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(json);
        String identifierString = JSONUtils.func_151219_a((JsonObject)object, (String)"function", null);
        if (ModUtils.isNullOrEmpty(identifierString)) {
            throw new JsonParseException("Invalid property value: 'function' must be defined and it's value cannot be empty");
        }
        ResourceLocation identifier = new ResourceLocation(identifierString);
        ICountFunctionAdapter adapter = CountFunctionRegistry.findByKey(identifier);
        if (adapter == null) {
            throw new JsonParseException(String.format("Invalid property value 'function': '%s' is not valid function", identifierString));
        }
        return adapter.deserialize(object, this.range);
    }
}

